<?php
/*--------------------------------------------------------------
   add_youtube_cookie_consent_purpose.php 2023-06-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

/** @var DatabaseModel $this */
/** @var int $t_success */
// Adds Youtube purpose if it does not exist

$youtubeCookiePurpose = $this->query("SELECT * FROM cookie_consent_panel_purposes WHERE purpose_alias = 'gambio/youtube'");
if (!$youtubeCookiePurpose) {
    $shopLanguages = $this->getLanguages();
    
    if ($shopLanguages) {
        $lastPurposeId = $this->query("SELECT purpose_id FROM cookie_consent_panel_purposes ORDER BY purpose_id DESC LIMIT 1", true);
        $lastPurposeId = (int)$lastPurposeId->fetch_assoc()['purpose_id'] + 1;
        
        $values = '';
        foreach ($shopLanguages as $language) {
            $values .= "({$lastPurposeId}, {$language['languages_id']}, 2, '', 'Youtube', 'gambio/youtube', 0, 0),";
        }
        
        if ($values) {
            $values = rtrim($values, ',');
            $insertQuery = "INSERT INTO `cookie_consent_panel_purposes`
                                (purpose_id, language_id, category_id, purpose_description, purpose_name, purpose_alias, purpose_status, purpose_deletable)
                                VALUES
                                {$values};
                            ";
            $t_success &= $this->query($insertQuery, true);
        }
    }
}